/* 
 *  RedialRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.ContactNumberI;

public class RedialRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(RedialRequest.class);
    private final ContactNumberI number;

    public RedialRequest(String interactionID, ContactNumberI number) {
        super(LOG, interactionID);
        this.number = number;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().redial(number);
        LOG.trace(methodName + "-");
        return null;
    }
}
